
#==============================================================================
# int16
#==============================================================================
# get signed decimal representation of a 16-bit 2s comp number

def int16( num ):

	if num > 0xFFFF:

		# overflow error
		raise OverflowError

	if num > 0x7FFF:

		# neg number
		
		return -(0x10000 - num)

	else:

		return num

#==============================================================================
# int8
#==============================================================================
# get signed decimal representation of a 8-bit 2s comp number

def int8( num ):

	if num > 0xFF:
		raise OverflowError

	if num > 0x7F:

		# neg number
		
		return -(0x100 - num)

	else:

		return num




